
from dataclasses import dataclass

@dataclass
class Lints:
    no_skip: bool = True
    diagnostics_leak_forbid: bool = True
    measure_invariance_strict: bool = True
    recentering_strict: bool = True
    kernel_primitivity_required: bool = True

    def assert_no_skip(self, hop: int):
        if self.no_skip and hop > 1:
            raise AssertionError("No-skip lint failed: hop > 1")

    def assert_measure_invariance(self, tilted: bool=False):
        if self.measure_invariance_strict and tilted:
            raise AssertionError("Measure invariance violated")

    def assert_kernel_primitivity(self, eta: float):
        if self.kernel_primitivity_required and eta <= 0.0:
            raise AssertionError("Kernel primitivity failed: eta <= 0")
